/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.network;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_638;
import potionstudios.byg.BYG;
import potionstudios.byg.network.packet.BYGS2CPacket;

public class FabricNetworkHandler {
    private static final String PACKET_LOCATION = "byg";
    private static final Map<Class<?>, BiConsumer<?, class_2540>> ENCODERS = new ConcurrentHashMap();
    private static final Map<Class<?>, class_2960> PACKET_IDS = new ConcurrentHashMap();

    public static void init() {
        BYGS2CPacket.S2C_PACKETS.forEach(FabricNetworkHandler::register);
    }

    private static <T extends BYGS2CPacket> void register(String path, BYGS2CPacket.Handler<T> handler) {
        FabricNetworkHandler.registerMessage(path, handler.clazz(), handler.write(), handler.read(), handler.handle());
    }

    private static <T> void registerMessage(String id, Class<T> clazz, BiConsumer<T, class_2540> encode, Function<class_2540, T> decode, BiConsumer<T, class_1937> handler) {
        ENCODERS.put(clazz, encode);
        PACKET_IDS.put(clazz, new class_2960(PACKET_LOCATION, id));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.registerClientReceiver(id, decode, handler);
        }
    }

    public static <MSG> void sendToPlayer(class_3222 player, MSG packet) {
        class_2960 packetId = PACKET_IDS.get(packet.getClass());
        BiConsumer<?, class_2540> encoder = ENCODERS.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf);
    }

    public static <MSG> void sendToAllPlayers(List<class_3222> players, MSG packet) {
        class_2960 packetId = PACKET_IDS.get(packet.getClass());
        BiConsumer<?, class_2540> encoder = ENCODERS.get(packet.getClass());
        class_2540 buf = new class_2540(Unpooled.buffer());
        encoder.accept(packet, buf);
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf));
    }

    public static class ClientProxy {
        public static <T> void registerClientReceiver(String id, Function<class_2540, T> decode, BiConsumer<T, class_1937> handler) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)new class_2960(FabricNetworkHandler.PACKET_LOCATION, id), (client, listener, buf, responseSender) -> {
                buf.retain();
                client.execute(() -> {
                    Object packet = decode.apply(buf);
                    class_638 level = client.field_1687;
                    if (level != null) {
                        try {
                            handler.accept((Object)packet, (class_1937)level);
                        }
                        catch (Throwable throwable) {
                            BYG.LOGGER.error("Packet failed: ", throwable);
                            throw throwable;
                        }
                    }
                    buf.release();
                });
            });
        }
    }
}

